/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.SQLFunction;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.Strings;

public class SelectSQLBuilderFactory {
    private final FunctionSQLBuilderFactory functionSQLBuilderFactory;

    public SelectSQLBuilderFactory(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping) {
        this(new FunctionSQLBuilderFactory(javaTypeToSqlTypeMapping));
    }

    public SelectSQLBuilderFactory(FunctionSQLBuilderFactory functionSQLBuilderFactory1) {
        this.functionSQLBuilderFactory = functionSQLBuilderFactory1;
    }

    public SelectSQLBuilder queryBuilder(Select select, DMLNameProvider dmlNameProvider) {
        return new SelectSQLBuilder(select, dmlNameProvider, this.functionSQLBuilderFactory.functionSQLBuilder(dmlNameProvider));
    }

    public static class SelectSQLBuilder
    implements SQLBuilder {
        private final Select select;
        private final DMLNameProvider dmlNameProvider;
        private final FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder;

        public SelectSQLBuilder(Select select, DMLNameProvider dmlNameProvider, FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder) {
            this.select = select;
            this.dmlNameProvider = dmlNameProvider;
            this.functionSQLBuilder = functionSQLBuilder;
        }

        @Override
        public String toSQL() {
            StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
            result.catIf(this.select.isDistinct(), "distinct ");
            this.cat(this.select, result);
            return result.getSQL();
        }

        private void cat(Iterable<? extends Selectable<?>> select, StringSQLAppender sql) {
            for (Selectable<?> o : select) {
                if (o instanceof SQLFunction) {
                    this.cat((SQLFunction)o, sql);
                } else if (o instanceof Selectable) {
                    this.cat(o, sql);
                } else if (o instanceof Iterable) {
                    this.cat((Iterable)((Object)o), sql);
                } else {
                    throw new UnsupportedOperationException("Operator " + Reflections.toString(o.getClass()) + " is not implemented");
                }
                sql.cat(", ", new String[0]);
            }
            if (Strings.tail((CharSequence)sql.getSQL(), (int)2).equals(", ")) {
                sql.removeLastChars(2);
            }
        }

        protected void cat(Selectable<?> column, StringSQLAppender sql) {
            String alias = this.select.getAliases().get(column);
            sql.catColumn((Selectable)column).catIf(!Strings.isEmpty((CharSequence)alias), " as " + alias);
        }

        private void cat(SQLFunction<?, ?> operator, StringSQLAppender appenderWrapper) {
            String alias = this.select.getAliases().get(operator);
            this.functionSQLBuilder.cat(operator, appenderWrapper);
            appenderWrapper.catIf(!Strings.isEmpty((CharSequence)alias), " as " + alias);
        }
    }
}

